<?php
/**
 * $produkte: Array von Produkt-Arrays
 */
?>
<div class="kadence-affrow">
    <?php foreach ($produkte as $produkt) { ?>
        <div class="kadence-affbox">
            <?php if (!empty($produkt['bild_url'])) { ?>
                <a href="<?php echo esc_url(site_url('/go/' . $produkt['slug'])); ?>" target="_blank" rel="nofollow sponsored noopener" class="affbox-image-wrapper">
                    <img src="<?php echo esc_url($produkt['bild_url']); ?>" alt="<?php echo esc_attr($produkt['titel']); ?>">
                </a>
            <?php } ?>
            <div class="affbox-content">
                <div class="affbox-title"><?php echo esc_html($produkt['titel']); ?></div>
                <?php if (!empty($produkt['beschreibung'])) { ?>
                    <div class="affbox-desc"><?php echo esc_html($produkt['beschreibung']); ?></div>
                <?php } ?>
                <a href="<?php echo esc_url(site_url('/go/' . $produkt['slug'])); ?>" target="_blank" rel="nofollow sponsored noopener" class="affbox-btn">
                    ➔ Bei <?php echo esc_html($produkt['shop']); ?> ansehen*
                </a>
            </div>
        </div>
    <?php } ?>
</div>
