<?php
/**
 * Vergleichstabelle mit $produkte, $all_keys
 * Kopf nur Bild (ohne Titel)
 */
?>
<div class="kadence-affcompare-wrapper">
    <table class="kadence-affcompare">
        <thead>
            <tr>
                <th></th>
                <?php foreach ($produkte as $produkt): ?>
                    <th>
                        <?php if (!empty($produkt['bild_url'])): ?>
    <a href="/go/<?php echo esc_attr($produkt['slug']); ?>/" target="_blank" rel="nofollow sponsored noopener">
        <img src="<?php echo esc_url($produkt['bild_url']); ?>" alt="<?php echo esc_attr($produkt['titel']); ?>" style="display:block; margin:0 auto; max-width:200px; max-height:200px;">
    </a>
                        <?php endif; ?>
                    </th>
                <?php endforeach; ?>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($all_keys as $key): ?>
                <tr>
                    <th><?php echo esc_html($key); ?></th>
                    <?php foreach ($produkte as $produkt): ?>
                        <td>
                            <?php
                            echo !empty($produkt['eigenschaften'][$key])
                                ? esc_html($produkt['eigenschaften'][$key])
                                : '—';
                            ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach; ?>
            <tr>
                <th></th>
                <?php foreach ($produkte as $produkt): ?>
                    <td>
                        <a href="<?php echo esc_url(site_url('/go/' . $produkt['slug'])); ?>" target="_blank" rel="nofollow sponsored noopener" class="affbox-btn">
            ➔ Bei <?php echo esc_html($produkt['shop']); ?> ansehen*
        </a>
                    </td>
                <?php endforeach; ?>
            </tr>
        </tbody>
    </table>
</div>

