<?php
/*
Plugin Name: Amazon Affiliate Produktbox Shortcode (mit Template)
Description: Shortcode für Amazon-Produktbox aus produkte.json, Template in separater Datei.
Version: 1.1
*/

function amazon_aff_box_shortcode($atts) {
    $atts = shortcode_atts([
        'id' => '',
        'asin' => ''
    ], $atts);

    $json_path = WP_CONTENT_DIR . '/uploads/produkte.json';
    if (!file_exists($json_path)) return '<div>Produktdaten nicht gefunden.</div>';
    $produkte = json_decode(file_get_contents($json_path), true);

    $produkt = null;
    foreach ($produkte as $p) {
        if (
            (!empty($atts['id']) && strval($p['id']) === strval($atts['id']))
            || (!empty($atts['asin']) && $p['asin'] === $atts['asin'])
        ) {
            $produkt = $p;
            break;
        }
    }
    if (!$produkt) return '<div>Produkt nicht gefunden.</div>';

    // Pfad zum Template (im selben Verzeichnis wie dieses Plugin)
    $template_path = plugin_dir_path(__FILE__) . 'template-aff-box.php';
    if (!file_exists($template_path)) return '<div>Template nicht gefunden.</div>';

    ob_start();
    // Variable $produkt steht im Template zur Verfügung!
    include $template_path;
    return ob_get_clean();
}
add_shortcode('amazon_aff_box', 'amazon_aff_box_shortcode');

function amazon_aff_row_shortcode($atts) {
    $atts = shortcode_atts([
        'ids' => '', // Kommagetrennte IDs
        'asins' => '', // Kommagetrennte ASINs (optional)
    ], $atts);

    $json_path = WP_CONTENT_DIR . '/uploads/produkte.json';
    if (!file_exists($json_path)) return '<div>Produktdaten nicht gefunden.</div>';
    $all_produkte = json_decode(file_get_contents($json_path), true);

    $selected = [];

    if (!empty($atts['ids'])) {
        $ids = array_map('trim', explode(',', $atts['ids']));
        foreach ($ids as $id) {
            foreach ($all_produkte as $produkt) {
                if (strval($produkt['id']) === strval($id)) {
                    $selected[] = $produkt;
                    break;
                }
            }
        }
    } elseif (!empty($atts['asins'])) {
        $asins = array_map('trim', explode(',', $atts['asins']));
        foreach ($asins as $asin) {
            foreach ($all_produkte as $produkt) {
                if ($produkt['asin'] === $asin) {
                    $selected[] = $produkt;
                    break;
                }
            }
        }
    }

    if (empty($selected)) return '<div>Keine Produkte gefunden.</div>';

    $template_path = plugin_dir_path(__FILE__) . 'template-aff-row.php';
    if (!file_exists($template_path)) return '<div>Template nicht gefunden.</div>';

    // $produkte steht im Template bereit!
    $produkte = $selected;

    ob_start();
    include $template_path;
    return ob_get_clean();
}
add_shortcode('amazon_aff_row', 'amazon_aff_row_shortcode');


function amazon_aff_compare_shortcode($atts) {
    $atts = shortcode_atts([
        'ids' => '', // Kommagetrennte IDs
        'asins' => '', // Kommagetrennte ASINs
    ], $atts);

    $json_path = WP_CONTENT_DIR . '/uploads/produkte.json';
    if (!file_exists($json_path)) return '<div>Produktdaten nicht gefunden.</div>';
    $all_produkte = json_decode(file_get_contents($json_path), true);

    $selected = [];
    if (!empty($atts['ids'])) {
        $ids = array_map('trim', explode(',', $atts['ids']));
        foreach ($ids as $id) {
            foreach ($all_produkte as $produkt) {
                if (strval($produkt['id']) === strval($id)) {
                    $selected[] = $produkt;
                    break;
                }
            }
        }
    } elseif (!empty($atts['asins'])) {
        $asins = array_map('trim', explode(',', $atts['asins']));
        foreach ($asins as $asin) {
            foreach ($all_produkte as $produkt) {
                if ($produkt['asin'] === $asin) {
                    $selected[] = $produkt;
                    break;
                }
            }
        }
    }
    if (empty($selected)) return '<div>Keine Produkte gefunden.</div>';

    $template_path = plugin_dir_path(__FILE__) . 'template-aff-compare.php';
    if (!file_exists($template_path)) return '<div>Template nicht gefunden.</div>';

    $produkte = $selected;

    // Alle möglichen Merkmale sammeln (nur in der Tabelle nutzen!)
    $all_keys = [];
    foreach ($produkte as $produkt) {
        if (!empty($produkt['eigenschaften']) && is_array($produkt['eigenschaften'])) {
            $all_keys = array_merge($all_keys, array_keys($produkt['eigenschaften']));
        }
    }
    $all_keys = array_unique($all_keys);

    ob_start();
    include $template_path;
    return ob_get_clean();
}
add_shortcode('amazon_aff_compare', 'amazon_aff_compare_shortcode');




// Amazon Affiliate Box CSS direkt im <head> einfügen
add_action('wp_head', function() {
    ?>
    <style>
    .kadence-affbox {
        max-width: 350px;
        margin: 1.2em auto;
        padding: 1.5em 1.2em 1.4em 1.2em;
        border-radius: 1.2em;
        box-shadow: 0 2px 18px 0 #0001;
        border: 1px solid #eee;
        background: #fff;
        display: flex;
        flex-direction: column;
        align-items: center;
    }
    .kadence-affbox .affbox-image-wrapper {
        width: 250px;
        height: 250px;
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
        border-radius: 1em;
        background: #faf9f7;
        box-shadow: 0 2px 12px #0001;
        margin-bottom: 1.1em;
    }
    .kadence-affbox .affbox-image-wrapper img {
        max-width: 100%;
        max-height: 100%;
        display: block;
        margin: auto;
    }
    .kadence-affbox .affbox-content {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
    }
    .kadence-affbox .affbox-title {
        font-weight: bold;
        font-size: 1.18em;
        color: #27241d;
        margin-bottom: 0.5em;
    }
    .kadence-affbox .affbox-desc {
        font-size: 1em;
        color: #504a40;
        margin-bottom: 1.0em;
    }
    .kadence-affbox .affbox-btn {
        display: inline-block;
        background: #dd6b20;
        color: #fff;
        font-weight: 600;
        padding: 0.52em 1.6em;
        border-radius: 100px;
        text-decoration: none;
        box-shadow: 0 2px 8px #dd6b2020;
        transition: background 0.2s, box-shadow 0.2s;
        font-size: 1.07em;
        letter-spacing: 0.01em;
        margin-top: 0.3em;
    }
    .kadence-affbox .affbox-btn:hover, .kadence-affbox .affbox-btn:focus {
        background: #cf3033;
        color: #fff;
        box-shadow: 0 4px 14px #cf303340;
    }
    .kadence-affrow {
        display: flex;
        flex-wrap: wrap;
        gap: 1.5em;
        justify-content: center;
        margin: 2em auto 2.2em auto;
        max-width: 1100px;
    }
    .kadence-affrow .kadence-affbox {
        flex: 1 1 300px;
        max-width: 340px;
        min-width: 240px;
    }
    @media (max-width: 900px) {
        .kadence-affrow {
            flex-direction: column;
            align-items: center;
        }
        .kadence-affrow .kadence-affbox {
            max-width: 95vw;
        }
    }
    @media (max-width: 480px) {
        .kadence-affbox .affbox-image-wrapper {
            width: 140px;
            height: 140px;
        }
        .kadence-affbox {
            padding: 1em 0.5em;
        }
    }
    .kadence-affcompare-wrapper {
        max-width: 100vw;
        overflow-x: auto;
        margin: 2.5em auto 2em auto;
    }
    .kadence-affcompare {
        width: 100%;
        max-width: 1150px;
        border-collapse: collapse;
        margin: 0 auto;
        background: #fff;
        border-radius: 1.2em;
        box-shadow: 0 2px 16px #0001;
        font-size: 1em;
    }
    .kadence-affcompare th,
    .kadence-affcompare td {
        padding: 0.65em 1.15em;
        border: 1px solid #e4e4e4;
        vertical-align: middle;
        text-align: center;
    }
    .kadence-affcompare th {
        background: #faf9f7;
        color: #504a40;
        font-weight: 600;
        text-align: left;
    }
    .kadence-affcompare thead th {
        background: #e8e6e1;
        font-size: 1.08em;
        border-bottom: 2px solid #dd6b20;
        text-align: center; /* Kopfzeile mittig */
    }
    .kadence-affcompare td {
        color: #27241d;
    }
    .kadence-affcompare img {
        display: block;
        margin: 0.5em auto 0.4em auto;
        background: #faf9f7;
        border-radius: 0.7em;
        max-width: 30px;    /* Bildgröße erhöht */
        max-height: 30px;
        object-fit: contain;
    }
    .kadence-affcompare .affbox-btn {
        margin: 0.3em 0 0 0;
        background: #dd6b20;
        color: #fff;
        font-weight: 600;
        padding: 0.36em 1.1em;
        border-radius: 9px !important;  /* Rundung 9px */
        text-decoration: none;
        transition: background 0.2s, box-shadow 0.2s;
        font-size: 0.90em;   /* Button kleiner */
        letter-spacing: 0.01em;
        box-shadow: 0 2px 8px #dd6b2020;
        display: inline-block;
    }
    .kadence-affcompare .affbox-btn:hover,
    .kadence-affcompare .affbox-btn:focus {
        background: #cf3033;
        color: #fff;
        box-shadow: 0 4px 14px #cf303340;
    }
    @media (max-width: 900px) {
        .kadence-affcompare th, .kadence-affcompare td { font-size: 0.95em; padding: 0.45em 0.5em;}
        .kadence-affcompare img { max-width: 100px; max-height: 100px;}
    }


    </style>
    <?php
});


